/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.maven;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.docgen.PluginSet;
import org.apache.logging.log4j.docgen.io.stax.PluginBundleStaxReader;
import org.apache.logging.log4j.docgen.maven.PathMatcherMojo;
import org.jspecify.annotations.Nullable;

final class PluginSets {
    PluginSets() {
    }

    static Set<PluginSet> ofDescriptorFilesAndFileMatchers(@Nullable File[] descriptorFiles, @Nullable PathMatcherMojo[] descriptorFileMatchers) {
        PathMatcherMojo[] effectiveDescriptorFileMatchers;
        File[] effectiveDescriptorFiles = descriptorFiles != null ? descriptorFiles : new File[]{};
        PathMatcherMojo[] pathMatcherMojoArray = effectiveDescriptorFileMatchers = descriptorFileMatchers != null ? descriptorFileMatchers : new PathMatcherMojo[]{};
        if (effectiveDescriptorFiles.length == 0 && effectiveDescriptorFileMatchers.length == 0) {
            throw new IllegalArgumentException("at least one of the `descriptorFiles` and `descriptorFileMatchers` configurations must be provided");
        }
        LinkedHashSet foundDescriptorPaths = new LinkedHashSet();
        Arrays.stream(effectiveDescriptorFiles).map(File::toPath).forEach(foundDescriptorPaths::add);
        Arrays.stream(effectiveDescriptorFileMatchers).forEach(matcher -> matcher.findPaths(foundDescriptorPaths::add));
        PluginBundleStaxReader reader = new PluginBundleStaxReader();
        return foundDescriptorPaths.stream().map(descriptorFile -> {
            try {
                return reader.read(descriptorFile.toString());
            }
            catch (Exception error) {
                String message = String.format("failed reading descriptor file `%s`", descriptorFile);
                throw new RuntimeException(message, error);
            }
        }).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

