/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.docgen.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;
import org.jspecify.annotations.Nullable;

public final class TypeFilterMojo {
    @Parameter
    private @Nullable String[] includes;
    @Parameter
    private @Nullable String[] excludes;

    Predicate<String> createPredicate() {
        String[] stringArray;
        if (this.includes != null && this.includes.length > 0) {
            stringArray = this.includes;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = ".*";
        }
        String[] effectiveIncludes = stringArray;
        List<Pattern> inclusionPatterns = TypeFilterMojo.compilePatterns("includes", effectiveIncludes);
        List<Pattern> exclusionPatterns = TypeFilterMojo.compilePatterns("excludes", this.excludes);
        return className -> {
            boolean included = inclusionPatterns.stream().anyMatch(pattern -> pattern.matcher((CharSequence)className).matches());
            if (included) {
                boolean excluded = exclusionPatterns.stream().anyMatch(pattern -> pattern.matcher((CharSequence)className).matches());
                return !excluded;
            }
            return false;
        };
    }

    private static List<Pattern> compilePatterns(String fieldName, @Nullable String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(patterns).map(pattern -> {
            try {
                return Pattern.compile(pattern);
            }
            catch (Exception error) {
                String message = String.format("invalid `%s` pattern: `%s`", fieldName, pattern);
                throw new IllegalArgumentException(message, error);
            }
        }).collect(Collectors.toList());
    }
}

