/*
 * Decompiled with CFR 0.152.
 */
package io.protostuff.runtime;

import io.protostuff.Input;
import io.protostuff.Output;
import io.protostuff.Pipe;
import io.protostuff.WireFormat;
import io.protostuff.runtime.Field;
import io.protostuff.runtime.IdStrategy;
import io.protostuff.runtime.RuntimeFieldFactory;
import io.protostuff.runtime.RuntimeMapField;
import io.protostuff.runtime.RuntimeMapFieldFactory;
import io.protostuff.runtime.RuntimeMapFieldProtobuf;
import java.io.IOException;
import java.util.Map;
import org.apache.servicecomb.foundation.common.utils.ReflectUtils;

public final class ProtobufCompatibleUtils {
    private static boolean inited = false;

    private ProtobufCompatibleUtils() {
    }

    public static void init() {
        if (inited) {
            return;
        }
        ProtobufCompatibleUtils.replaceRuntimeFieldFactoryMap();
        inited = true;
    }

    protected static void replaceRuntimeFieldFactoryMap() {
        final RuntimeFieldFactory org = RuntimeMapFieldFactory.MAP;
        RuntimeFieldFactory map = new RuntimeFieldFactory<Map<?, ?>>(26){

            public WireFormat.FieldType getFieldType() {
                return org.getFieldType();
            }

            public Map<?, ?> readFrom(Input input) throws IOException {
                return (Map)org.readFrom(input);
            }

            public void writeTo(Output output, int number, Map<?, ?> value, boolean repeated) throws IOException {
                org.writeTo(output, number, value, repeated);
            }

            public void transfer(Pipe pipe, Input input, Output output, int number, boolean repeated) throws IOException {
                org.transfer(pipe, input, output, number, repeated);
            }

            public Class<?> typeClass() {
                return org.typeClass();
            }

            public <T> Field<T> create(int number, String name, java.lang.reflect.Field field, IdStrategy strategy) {
                RuntimeMapField runtimeMapField = (RuntimeMapField)org.create(number, name, field, strategy);
                return new RuntimeMapFieldProtobuf(runtimeMapField, field);
            }
        };
        ReflectUtils.setField(RuntimeMapFieldFactory.class, null, (String)"MAP", (Object)map);
    }
}

