/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core;

import com.netflix.config.DynamicPropertyFactory;
import javax.inject.Inject;
import org.apache.servicecomb.core.BootListener;
import org.apache.servicecomb.core.definition.schema.ProducerSchemaFactory;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.metrics.MetricsBootstrap;
import org.apache.servicecomb.foundation.metrics.MetricsInitializer;
import org.apache.servicecomb.foundation.metrics.registry.GlobalRegistry;
import org.apache.servicecomb.metrics.core.publish.MetricsRestPublisher;
import org.apache.servicecomb.metrics.core.publish.SlowInvocationLogger;
import org.springframework.stereotype.Component;

@Component
public class MetricsBootListener
implements BootListener {
    private MetricsBootstrap metricsBootstrap = new MetricsBootstrap();
    @Inject
    private ProducerSchemaFactory producerSchemaFactory;
    private SlowInvocationLogger slowInvocationLogger;

    public MetricsBootstrap getMetricsBootstrap() {
        return this.metricsBootstrap;
    }

    public SlowInvocationLogger getSlowInvocationLogger() {
        return this.slowInvocationLogger;
    }

    public void onBootEvent(BootListener.BootEvent event) {
        switch (event.getEventType()) {
            case BEFORE_PRODUCER_PROVIDER: {
                this.registerSchemas();
                break;
            }
            case AFTER_REGISTRY: {
                this.slowInvocationLogger = new SlowInvocationLogger(event.getScbEngine());
                this.metricsBootstrap.start(new GlobalRegistry(), EventManager.getEventBus());
                break;
            }
            case BEFORE_CLOSE: {
                this.metricsBootstrap.shutdown();
                break;
            }
        }
    }

    private void registerSchemas() {
        if (!DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.metrics.endpoint.enabled", true).get()) {
            return;
        }
        MetricsRestPublisher metricsRestPublisher = (MetricsRestPublisher)SPIServiceUtils.getTargetService(MetricsInitializer.class, MetricsRestPublisher.class);
        this.producerSchemaFactory.getOrCreateProducerSchema("metricsEndpoint", metricsRestPublisher.getClass(), (Object)metricsRestPublisher);
    }
}

