/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cloudfoundry;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.endpoint.mvc.AbstractMvcEndpoint;
import org.springframework.boot.actuate.endpoint.mvc.NamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

class CloudFoundryDiscoveryMvcEndpoint
extends AbstractMvcEndpoint {
    private final Set<NamedMvcEndpoint> endpoints;

    CloudFoundryDiscoveryMvcEndpoint(Set<NamedMvcEndpoint> endpoints) {
        super("", false);
        this.endpoints = endpoints;
    }

    @RequestMapping(produces={"application/json"})
    @ResponseBody
    public Map<String, Map<String, Link>> links(HttpServletRequest request) {
        LinkedHashMap<String, Link> links = new LinkedHashMap<String, Link>();
        String url = request.getRequestURL().toString();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        links.put("self", Link.withHref(url));
        AccessLevel accessLevel = AccessLevel.get(request);
        for (NamedMvcEndpoint endpoint : this.endpoints) {
            if (accessLevel == null || !accessLevel.isAccessAllowed(endpoint.getPath())) continue;
            links.put(endpoint.getName(), Link.withHref(url + "/" + endpoint.getName()));
        }
        return Collections.singletonMap("_links", links);
    }

    static class Link {
        private String href;

        Link() {
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        static Link withHref(Object href) {
            Link link = new Link();
            link.setHref(href.toString());
            return link;
        }
    }
}

