// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pcommon

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
)

func TestResource_MoveTo(t *testing.T) {
	ms := Resource(internal.GenerateTestResource())
	dest := NewResource()
	ms.MoveTo(dest)
	assert.Equal(t, NewResource(), ms)
	assert.Equal(t, Resource(internal.GenerateTestResource()), dest)
}

func TestResource_CopyTo(t *testing.T) {
	ms := NewResource()
	orig := NewResource()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = Resource(internal.GenerateTestResource())
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
}

func TestResource_Attributes(t *testing.T) {
	ms := NewResource()
	assert.Equal(t, NewMap(), ms.Attributes())
	internal.FillTestMap(internal.Map(ms.Attributes()))
	assert.Equal(t, Map(internal.GenerateTestMap()), ms.Attributes())
}

func TestResource_DroppedAttributesCount(t *testing.T) {
	ms := NewResource()
	assert.Equal(t, uint32(0), ms.DroppedAttributesCount())
	ms.SetDroppedAttributesCount(uint32(17))
	assert.Equal(t, uint32(17), ms.DroppedAttributesCount())
}
